
// Copyright  2000-2010 Luigi Pino. All Rights Reserved.

/***************************************************************************/

#include "../neurosis/neurosis.h"
#include "extra.h"
#include "render.h"

/***************************************************************************/

#ifdef _DEBUG
	CWindow		gWindow(0.1f, 150.0f, "log.dat", "Halloween Fighter 2D00 :: v1.01", true);
#else
	CWindow		gWindow(0.1f, 150.0f, NULL, "Halloween Fighter 2D00 :: v1.01", false);
#endif

bool				gFullscreen = false;
bool				gKicking = false;
bool				gMoving = false;
bool				gScrollMenu = false;
bool				gShowMenu = true;
bool				gWalking = false;
CTiming			gTiming;
float				gDirection = 1.0f;
float				gMonsterMovement = 0.0f;
float				gPositionMonsters = 0.0f;
float				gPositionMoon = 1.0f;
float				gPositionPerson = 0.0f;
float				gPositionScenery = -1.5f;
float				gPositionTombstones = 0.0f;
float				gScroll = 5.0f;
float				gTimerKicking = 0.0f;
float				gTimerWalking = 0.0f;
float2			gPictureAdjustment;
float3			gRain[RAIN_TOTAL];
int					gKickingFrame = 1;
int					gWalkingFrame = 1;
SMonster		gMonster[3];
STombstone	gTombstone[6];

/***************************************************************************/

void Initialize_Textures()

{
	if ((!gWindow.Font_List_Load("data/textures/_font_list.txt")) ||
			(gWindow.Texture_Load("data/textures/_font.png", TEXTURE_FONT) == -1) ||
			(gWindow.Texture_Load("data/textures/monster_1.png", TEXTURE_MONSTER_1) == -1) ||
			(gWindow.Texture_Load("data/textures/monster_2.png", TEXTURE_MONSTER_2) == -1) ||
			(gWindow.Texture_Load("data/textures/monster_3.png", TEXTURE_MONSTER_3) == -1) ||
			(gWindow.Texture_Load("data/textures/moon.png", TEXTURE_MOON) == -1) ||
			(gWindow.Texture_Load("data/textures/person_kick.png", TEXTURE_PERSON_KICK) == -1) ||
			(gWindow.Texture_Load("data/textures/person_walk.png", TEXTURE_PERSON_WALK) == -1) ||
			(gWindow.Texture_Load("data/textures/rain.png", TEXTURE_RAIN) == -1) ||
			(gWindow.Texture_Load("data/textures/scenery.png", TEXTURE_SCENERY) == -1) ||
			(gWindow.Texture_Load("data/textures/title_1.png", TEXTURE_TITLE_1) == -1) ||
			(gWindow.Texture_Load("data/textures/title_2.png", TEXTURE_TITLE_2) == -1) ||
			(gWindow.Texture_Load("data/textures/tombstone.png", TEXTURE_TOMBSTONE) == -1))
	{
		MessageBox(NULL, "Could not load required files.", "Halloween Fighter 2D00", MB_OK | MB_ICONEXCLAMATION);
		exit(1);
	}
}

/***************************************************************************/

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)

{
	File_Get_Parameters();

	// Get screen mode preference
	gWindow.mScreenHeight = (int)((float)(GetSystemMetrics(SM_CYVIRTUALSCREEN)) * 0.8f);
	gWindow.mScreenWidth = (int)((float)(gWindow.mScreenHeight) / (3.0f / 4.0f));

	// Create OpenGL window
	if (gWindow.GL_Create_Window("Halloween Fighter 2D00", gWindow.mScreenWidth, gWindow.mScreenHeight, 16, gFullscreen, TRUE, TRUE, TRUE) == false)
		exit(1);

	// Initialize misc
	srand((unsigned)(time(NULL)));
	Initialize_Textures();
	Initialize_Values();

	// Initialize timing
	gTiming.Update();

	while (gWindow.mQuit == false)
	{
		gTiming.Update();
		gWindow.Process_Messages();

		if (gWindow.mActive == true)
		{
			Update_Input_Keyboard();
			Update_Game();

			Render_Game();
			SwapBuffers(gWindow.hDC);
		}
	}

	// Shutdown
	return (int)(gWindow.mMsg.wParam);
}

/***************************************************************************/